#include <allegro.h>
#include <stdio.h>

#include "main.h"
#include "chat.h"
#include "pbox.h"

BITMAP *buffer;
int quit = 0;

int enter_name(char *name, int max_len)
{
	DIALOG the_dialog[] =
   {
      /* (dialog proc)     (x)   (y)   (w)   (h)
                           (fg)  (bg)  (key) (flags)
                           (d1)  (d2)  (dp) */
      { d_clear_proc,      0,    0,    0,    0,
                           0,    0,    0,    0,
                           0,    0,    NULL, 0,0 },

      { d_edit_proc,       GAME_W/2 - (max_len+2)*4+24, GAME_H/2 - 16,   (max_len+2)*8,  8,
                           14,  15,    0,    0,
                           max_len,   0,    name, 0,0 },

	  { d_text_proc,	   GAME_W/2 - (max_len+2)*4-24,GAME_H/2 - 16, 0,0, 14,15, 0,0, 0,0, "NAME: ", 0,0},
      
      { d_button_proc,     GAME_W/2-64,   GAME_H/2+12,  64,  16,
                           14,  13,    0,    D_EXIT,
                           0,    0,    "OK" , 0,0},
   
      { d_button_proc,     GAME_W/2+8,  GAME_H/2+12,  64,  16,
                           14,  13,    0,    D_EXIT,
                           13,    0,    "CANCEL" , 0,0},
   
      { NULL,              0,    0,    0,    0,
                           0,    0,    0,    0,
                           0,    0,    NULL , 0,0}
   };

	DIALOG_PLAYER *dp = init_dialog(the_dialog, 1);
	
	int result;
	clear(buffer);

	show_mouse(NULL);
	gui_set_screen(buffer);

	clear_keybuf();

	while (update_dialog(dp))
	{
		blit(buffer, gfx_frame_start(gfx), 0,0, 0,0, GAME_W,GAME_H);
		gfx_frame_end(gfx);
	} 

	show_mouse(NULL);

	result = dp->obj;
	shutdown_dialog(dp);

	return result == 3;
}


typedef struct USER
{
	char name[10];
	struct USER *next;
} USER;

USER *users = 0;
int user_count = 0;

char *proc_user_list(int index, int *list_size)
{	
	if (index < 0)
	{
		*list_size = user_count;
		return NULL;
	}
	else
	{
		USER *tmp = users;

		TRACE("Looking for %d\n", index);

		while (tmp && index--)
		{
			tmp = tmp->next;
		}

		if (tmp) return tmp->name;
	}

	return NULL;
}

char *chatlog;
void chat_add_line(char *buffer, const char *format, ...)
{
	char line[1024];
	va_list args;
	va_start(args, format);
	_vsnprintf(line, 1024, format, args);
	va_end(args);
	line[1023] = 0;
	
	if (strlen(buffer) > 2500) buffer[0] = 0;

	TRACE("%s", line);
	strcpy(buffer + strlen(buffer), line);
	buffer[strlen(buffer) + 1] = 0;
	buffer[strlen(buffer)] = '\n';
}

int d_edit_proc_enter(int msg, DIALOG *d, int c)
{
	int (*foo)(DIALOG *) = d->dp2;
	return (msg == MSG_CHAR && (c>>8) == KEY_ENTER) ? (*foo)(d) : d_edit_proc(msg, d, c);
}

char chatline[1206];
int command_match(const char *string, const char *command)
{
	unsigned int i;
	int len1 = strlen(string);
	int len2 = strlen(command);

	/* if it's the wrong length and doesn't have a space we know it's wrong */
	if (len1 < len2 || (len1 > len2 && string[len2] != ' ')) return FALSE;

	for (i=0; i<strlen(command); i++)
		if (string[i] != command[i] && (string[i] - 0x20 != command[i])) return FALSE;

	return TRUE;
}

int send_text(DIALOG *d)
{
	ENetPacket *packet;
	PACKET_BOX *pb = NULL;
	char *text = d->dp;

	if (text[0] != '/')
	{	
		if (text[0] != 0)
		{
			pb = packet_box_create("TALK");
			packet_box_add_string(pb, text);
			chat_add_line(chatlog, "Me> %s", text);
		}
	}
	else if (command_match(text, "/QUIT") || command_match(text, "/EXIT"))
	{
		quit = 1;
	}
	else if (command_match(text, "/HELP"))
	{
		pb = packet_box_create("HELP");
	}
	else if (command_match(text, "/CREATE"))
	{	
		int players = 4;
		pb = packet_box_create("CREA");
		
		if (strlen(text) >= 9)
		{
			players = text[8] - '0';
			if (players < 2 || players > 4) players = 4;
		}		
		packet_box_add_int(pb, players, 8);
	}
	else if (command_match(text, "/JOIN"))
	{	
		if (strlen(text) >= 6)
		{
			pb = packet_box_create("PLAY");		
			if (pb) packet_box_add_string(pb, text+6);
		}
	}
	else if (command_match(text, "/GAMES"))
	{
		pb = packet_box_create("GLST");
	}

	if (pb)
	{
		packet_box_serialize(pb);
		packet = enet_packet_create(pb->data, pb->size, ENET_PACKET_FLAG_RELIABLE);
		enet_peer_send(peer, 0, packet);		
		packet_box_destroy(pb);
	}
	
	text[0] = 0;
	object_message(d, MSG_DRAW, 0);
	
	return D_USED_CHAR;
}


int chat_enter()
{
    ENetAddress address;
	ENetPacket * packet;
	ENetEvent event;
	char name[50];

	buffer = create_bitmap(GAME_W, GAME_H);
	
	name[0] = 0;
	if (!enter_name(name, 8) || name[0] == 0)
	{
		destroy_bitmap(buffer);
		return 0;
	}

	enet_address_set_host (& address, get_config_string("network", "server", "192.168.0.1"));
    address.port = 36927;

	client = enet_host_create (NULL, 1, 5, 5);

    /* Initiate the connection, allocating these channels:
		OUTGOING                            
		0: Data sent to the server.         
		1: If game host, sent to other players; If client, sent to game host.
		2: Private data to player #2  
		3: Private data to player #3
		4: Private data to player #4

		INCOMING channels are about the same, but a little messed up.
	*/
    peer = enet_host_connect (client, & address, 5);  
    
    if (peer == NULL)
    {
       TRACE("No available peers for initiating an ENet connection.\n");
       exit (EXIT_FAILURE);
    }

	gfx_frame_start(gfx);
	textprintf_ex(buffer, font64, 0,0, 14,15, " TRYING TO JOIN WAR ROOM...             ");
	blit(buffer, gfx_frame_start(gfx), 0,0, 0,0, GAME_W,GAME_H);
	gfx_frame_end(gfx);
	rest(100);

    
    /* Wait up to 5 seconds for the connection attempt to succeed. */
    if (enet_host_service (client, & event, 5000) > 0 &&
        event.type == ENET_EVENT_TYPE_CONNECT)
    {
		TRACE("Connected!\n");
    }
    else
    {        
		enet_peer_reset (peer);
		gfx_frame_start(gfx);                     
		textprintf_ex(buffer, font64, 0,0, 14,15, " TRYING TO JOIN WAR ROOM... FAILED!  :( ");
		blit(buffer, gfx_frame_start(gfx), 0,0, 0,0, GAME_W,GAME_H);
		gfx_frame_end(gfx);
		destroy_bitmap(buffer);
		readkey();        
		return 0;
    }

	{
		DIALOG the_dialog[] =
		{
			/* (dialog proc)		(x)			(y)		(w)		(h)			(fg)		(bg)		(key)		(flags)		(d1)		(d2)		(dp) */
			{ d_clear_proc,		0,			0,		0,		0,			15,	0,	0,			0,			0,			0,			NULL , 0,0},
			{ d_list_proc,		GAME_W-7*12,0,		8*12,	GAME_H-8,	15,	14,	0,			0,			0,			0,			proc_user_list , 0,0},
			{ d_textbox_proc,	0,0,	GAME_W-7*12,GAME_H-8,	14,2,	0,0,	0,0,	0 , 0,0},
			{ d_edit_proc_enter,		0,GAME_H-8,	GAME_W,16,	14,2,	0,0,	200,0,	chatline , send_text,0},
			{ NULL,				0,			0,		0,		0,			0,			0,			0,			0,			0,			0,			NULL , 0,0}
		};

		DIALOG_PLAYER *dplayer = init_dialog(the_dialog, 3);

		
		the_dialog[2].dp = chatlog = malloc(5000);
		chatline[0] = 0;

		if (chatlog)
			strcpy(chatlog, "Welcome to the War Room!\n\nFor help, type \"/help\"\n\n");

		show_mouse(NULL);

		quit = 0;

		while(update_dialog(dplayer) && !key[KEY_ESC] && !quit)
		{
			blit(buffer, gfx_frame_start(gfx), 0,0, 0,0, GAME_W,GAME_H);
			gfx_frame_end(gfx);

			if (!(the_dialog[2].flags & D_GOTFOCUS) && the_dialog[2].d1 > 23) the_dialog[2].d2 = the_dialog[2].d1 - 23;

			while (enet_host_service (client, & event, 10) > 0)
			{
				switch (event.type)
				{
					case ENET_EVENT_TYPE_RECEIVE:					
						if (event.packet->dataLength > 4)
						{
							char cmd[5];
							strncpy(cmd, event.packet->data, 4);
							cmd[4] = 0;

							TRACE("> %s\n", cmd);							

							if (!strcmp(cmd, "AUTH"))
							{
								TRACE("< AUTH%s\n", name);
								packet = enet_packet_create(NULL, 6 + strlen(name), ENET_PACKET_FLAG_RELIABLE);
								strcpy(packet->data, "AUTH");
								strcpy(packet->data + 5, name);

								enet_peer_send(event.peer, 0, packet);
							}

							else if (!strcmp(cmd, "AUOK"))
							{
								TRACE("< LIST\n");
								packet = enet_packet_create("LIST", 5, ENET_PACKET_FLAG_RELIABLE);
								enet_peer_send(event.peer, 0, packet);
							}

							else if (!strcmp(cmd, "LIST"))
							{              
								unsigned int i = 5; 

								TRACE("People in channel: \n");
								
								user_count = 0;
								while (users)
								{
									USER *tmp = users->next;
									free(users);
									users = tmp;									
								}

								
								while (i < event.packet->dataLength)
								{
									USER *new_user = (USER *) malloc(sizeof(USER));
									new_user->next = users;
									users = new_user;
									strncpy(new_user->name, event.packet->data + i, 10);
									new_user->name[9] = 0;
									user_count++;

									TRACE("\t%s\n", event.packet->data + i);
									i += (strlen(event.packet->data + i) + 1);
								}

								object_message(&the_dialog[1], MSG_DRAW, 0);
								object_message(&the_dialog[2], MSG_DRAW, 0);
							}

							else if (!strcmp(cmd, "JOIN"))
							{
								USER *new_user = (USER *) malloc(sizeof(USER));
								new_user->next = users;
								users = new_user;
								strncpy(new_user->name, event.packet->data + 5, 10);
								new_user->name[9] = 0;
								user_count++;

								chat_add_line(chatlog, "*** %s has entered.", event.packet->data + 5);
								object_message(&the_dialog[1], MSG_DRAW, 0);
								object_message(&the_dialog[2], MSG_DRAW, 0);
							}

							else if (!strcmp(cmd, "QUIT"))
							{
								PACKET_BOX *pb = packet_box_unserialize(event.packet->data, event.packet->dataLength);
								if (pb)
								{
									char buffer[400];
									packet_box_get_string(pb, buffer, 400);
									packet_box_destroy(pb);	

									if (buffer)
									{
										USER *tmp = users;
										USER *prev = 0;
								
								
										while (tmp)
										{
											if (!strcmp(tmp->name, buffer))
											{
												if (prev)										
													prev->next = tmp->next;
												else
													users = tmp->next;

												free(tmp);

												user_count--;

												break;
											}
											prev = tmp;
											tmp = tmp->next;
										}
										
								
										chat_add_line(chatlog, "*** %s has left.", buffer);
										object_message(&the_dialog[1], MSG_DRAW, 0);
										object_message(&the_dialog[2], MSG_DRAW, 0);
									}									
								}
							}

							else if (!strcmp(cmd, "TALK"))
							{
								if (strcmp(event.packet->data + 5, name))
								{
									chat_add_line(chatlog, "%s> %s", event.packet->data + 5, event.packet->data + 6 +strlen(event.packet->data + 5));
									object_message(&the_dialog[2], MSG_DRAW, 0);
								}
							}

							else if (!strcmp(cmd, "NOTE"))
							{
								PACKET_BOX *pb = packet_box_unserialize(event.packet->data, event.packet->dataLength);
								if (pb)
								{
									char buffer[400];
									packet_box_get_string(pb, buffer, 400);
									packet_box_destroy(pb);
									chat_add_line(chatlog, "*** %s", buffer);
								}
							}

							else if (!strcmp(cmd, "GLST"))
							{
								PACKET_BOX *pb = packet_box_unserialize(event.packet->data, event.packet->dataLength);								
								if (pb)
								{
									char buffer[400];
									int current_pc, max_pc = -1;

									chat_add_line(chatlog, "*** Game List:");

									while ((current_pc = packet_box_get_int(pb)))
									{
										max_pc = packet_box_get_int(pb);
										packet_box_get_string(pb, buffer, 400);
										chat_add_line(chatlog, " %s: (%d/%d)", buffer, current_pc,max_pc);
									}

									if (max_pc == -1) chat_add_line(chatlog, " Empty.\n\nUse the CREATE command to make one.");
									packet_box_destroy(pb);									
								}
							}

							else if (!strcmp(cmd, "REDY"))
							{
								PACKET_BOX *pb = packet_box_unserialize(event.packet->data, event.packet->dataLength);								
								if (pb)
								{
									quit = 2 + packet_box_get_int(pb);
								}
							}
						}

						enet_packet_destroy(event.packet);
					break;

					case ENET_EVENT_TYPE_DISCONNECT:
						quit = 1;
					break;

					case ENET_EVENT_TYPE_CONNECT:
					case ENET_EVENT_TYPE_NONE:
					break;
				}
			}


			object_message(&the_dialog[2], MSG_DRAW, 0);
			TRACE(".");

		}

		shutdown_dialog(dplayer);


		if (chatlog) free(chatlog);
	}

	if (quit == 1)
	{
		enet_peer_disconnect (peer);
		enet_host_flush(client);
	}

	return quit - 1;
}

